<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:variable name="mnlno"></xsl:variable>
	<xsl:variable name="drawno"></xsl:variable>
	<xsl:template match="/">
		<table id='tblmynote' width='100%' border='1' cellspacing='0' cellpadding='1' bordercolordark='#FFFFFF' bordercolor='#777777'>
			<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
				<th colspan='10'>
					<div align='left'>
						My Note List
					</div>
				</th>
			</tr>
			<tr height='23' bgcolor='threedface'>
				<th nowrap="nowrap">ID</th>
				<th nowrap="nowrap">MODEL</th>
				<th nowrap="nowrap">BLOCK</th>
				<th nowrap="nowrap">REF</th>
				<th>TITLE</th>
				<th nowrap="nowrap">CLASS</th>
				<th nowrap="nowrap">DATE</th>
				<th nowrap="nowrap">ATTACH</th>
				<th nowrap="nowrap">LINK</th>
				<th nowrap="nowrap">
					<input type="file" id="file" name="importFile" style="display:none"/>
					<input type="button" id="btn" value="Import..." onClick="importFile.click();showImport();"/>
				</th>
			</tr>
			<xsl:if test="$drawno != ''">
				<xsl:apply-templates select="//INFO[@DRAW=$drawno and @MNLNO=$mnlno]">
		            <xsl:sort select="@DATE" order="descending"/>
		       </xsl:apply-templates>
			</xsl:if>
			<xsl:if test="$drawno = ''">
				<xsl:apply-templates select="//INFO[@MNLNO=$mnlno]">
		            <xsl:sort select="@DATE" order="descending"/>
		       </xsl:apply-templates>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="//INFO">
		<tr height='23'>
			<td align="center" nowrap="nowrap">
				<xsl:value-of select="position()"/>
			</td>
			<td>
				<xsl:if test="MODEL[. != '']"><xsl:value-of select="MODEL"/></xsl:if>
				<xsl:if test="MODEL[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<a>
					<xsl:attribute name="href">
						javascript:SearchDraws(<xsl:value-of select="@VIEW"/>,'<xsl:value-of select="@DRAWS"/>');window.close();
					</xsl:attribute>
				</a>
				<xsl:if test="MODEL/@BLOCKNO[. != '']"><xsl:value-of select="MODEL/@BLOCKNO"/></xsl:if>
				<xsl:if test="MODEL/@BLOCKNO[. = '']">??</xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="MODEL/@BLOCKNO[. != '']">
					<a>
						<xsl:attribute name="href">
							javascript:SearchDraws(<xsl:value-of select="@VIEW"/>,'<xsl:value-of select="@DRAWS"/>');SerachPartsRef('<xsl:value-of select="MODEL/@REFNO"/>','<xsl:value-of select="MODEL/@BLOCKNO"/>');window.close();
						</xsl:attribute>
					</a>
				</xsl:if>
				<xsl:if test="MODEL/@REFNO[. != '']"><xsl:value-of select="MODEL/@REFNO"/></xsl:if>
				<xsl:if test="MODEL/@REFNO[. = '']"><br/></xsl:if>
			</td>
			<td width="200">
				<a>
					<xsl:attribute name="href">
						javascript:viewNote('<xsl:value-of select="@ID"/>');window.close();
					</xsl:attribute>
				</a>
				<xsl:if test="@TITLE[. != '']"><xsl:value-of select="@TITLE"/></xsl:if>
				<xsl:if test="@TITLE[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="NOTE/@CLASS[. != '']"><xsl:value-of select="NOTE/@CLASS"/></xsl:if>
				<xsl:if test="NOTE/@CLASS[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="@DATE[. != '']"><xsl:value-of select="@DATE"/></xsl:if>
				<xsl:if test="@DATE[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<input type="checkbox" name="attach" disabled="disabled">
					<xsl:if test="ATTACH[. != '']">
						<xsl:attribute name="checked">checked</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<td nowrap="nowrap">
				<input type="checkbox" name="link" disabled="disabled">
					<xsl:if test="LINK[. != '']">
						<xsl:attribute name="checked">checked</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<td nowrap="nowrap">
				<input type="button" id="btn" value="Delete...">
					<xsl:attribute name="onclick">deleteNote('<xsl:value-of select="@ID"/>')</xsl:attribute>
				</input>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
